/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpEngine;

import ibm.nways.analysis.dpEngine.DpeCounters;
import ibm.nways.analysis.dpEngine.NodeStats;
import ibm.nways.jdm.snmp.FullSnmpStats;
import java.io.Serializable;
import java.util.Date;
import java.util.Vector;

public class DpeStats
implements Serializable {
    public String hostname;
    public long date;
    public int totalPDUs;
    public int totalSentVars;
    public int totalReceivedVars;
    public int healthCounter;
    public Vector nodes;
    public long totalMemory;
    public long freeMemory;
    public DpeCounters counters;
    public boolean fullInterval;

    public String getHostname() {
        return this.hostname;
    }

    public long getDate() {
        return this.date;
    }

    public int getHealthCounter() {
        return this.healthCounter;
    }

    public Vector getNodes() {
        return this.nodes;
    }

    public long getTotalMemory() {
        return this.totalMemory;
    }

    public long getFreeMemory() {
        return this.freeMemory;
    }

    public DpeStats(String string, long l, FullSnmpStats fullSnmpStats, FullSnmpStats fullSnmpStats2, int n, Vector vector, long l2, long l3, DpeCounters dpeCounters, boolean bl) {
        this.hostname = string;
        this.date = l;
        if (fullSnmpStats2 != null) {
            this.totalPDUs = fullSnmpStats.sends - fullSnmpStats2.sends;
            this.totalSentVars = fullSnmpStats.varbindsSent - fullSnmpStats2.varbindsSent;
            this.totalReceivedVars = fullSnmpStats.varbindsRecv - fullSnmpStats2.varbindsRecv;
        } else {
            this.totalPDUs = fullSnmpStats.sends;
            this.totalSentVars = fullSnmpStats.varbindsSent;
            this.totalReceivedVars = fullSnmpStats.varbindsRecv;
        }
        this.healthCounter = n;
        this.nodes = vector;
        this.totalMemory = l2;
        this.freeMemory = l3;
        this.counters = dpeCounters;
        this.fullInterval = bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("DPE statistics:\n");
        stringBuffer.append("DPE on host: ");
        stringBuffer.append(this.hostname);
        stringBuffer.append("\nat time : ");
        stringBuffer.append(new Date(this.date).toString());
        stringBuffer.append("\n healthCounter (50=perfect, -50=overload) = ");
        stringBuffer.append(this.healthCounter);
        stringBuffer.append("\n");
        stringBuffer.append("\n DPE counters : ");
        stringBuffer.append(this.counters.toString());
        stringBuffer.append("\n SNMP counters: ");
        stringBuffer.append(this.totalPDUs);
        stringBuffer.append("  PDUs sent, ");
        stringBuffer.append("\n    ");
        stringBuffer.append(this.totalSentVars);
        stringBuffer.append(" MIB variables requested, ");
        stringBuffer.append(this.totalReceivedVars);
        stringBuffer.append(" MIB variables received.\n");
        stringBuffer.append("full interval? : ");
        stringBuffer.append(this.fullInterval);
        stringBuffer.append("\n");
        int n = 0;
        while (n < this.nodes.size()) {
            NodeStats nodeStats = (NodeStats)this.nodes.elementAt(n);
            stringBuffer.append(" ");
            stringBuffer.append(nodeStats.ipAddress);
            stringBuffer.append("\n");
            stringBuffer.append("   minRsp=");
            stringBuffer.append(nodeStats.minRspTime);
            stringBuffer.append("   maxRsp=");
            stringBuffer.append(nodeStats.maxRspTime);
            stringBuffer.append("   timeouts=");
            stringBuffer.append(nodeStats.timeouts);
            stringBuffer.append("   sends=");
            stringBuffer.append(nodeStats.sends);
            stringBuffer.append("   retries=");
            stringBuffer.append(nodeStats.retries);
            stringBuffer.append("\n");
            ++n;
        }
        stringBuffer.append("Total Memory:" + this.totalMemory);
        stringBuffer.append("\nFree  Memory:" + this.freeMemory);
        return stringBuffer.toString();
    }
}

